<?php
// Load config file to get the data directory
require_once __DIR__ . '/config.php';

if (!defined('PINETRACK_DATA_DIR')) {
    define('PINETRACK_DATA_DIR', __DIR__ . '/data/');
}

$files = [
    PINETRACK_DATA_DIR . '/gclids.csv',
    PINETRACK_DATA_DIR . '/msclkids.csv'
];

$maxAge = 90 * 86400; // 90 days in seconds
$now = time();
$log = [];

function logLine($message) {
    global $log;
    $log[] = '[' . date('Y-m-d H:i:s') . '] ' . $message;
}

foreach ($files as $file) {
    if (!file_exists($file)) {
        logLine("Skipped missing file: $file");
        continue;
    }

    $lines = file($file);
    if ($lines === false) {
        logLine("Failed to read file: $file");
        continue;
    }

    $headers = [];
    $filtered = [];
    $removed = 0;

    foreach ($lines as $line) {
        if (
            stripos($line, 'Google Click ID') !== false ||
            stripos($line, 'Microsoft Click ID') !== false ||
            stripos($line, 'Parameters:') !== false ||
            stripos($line, '###') !== false
        ) {
            $headers[] = $line;
            continue;
        }

        $parts = str_getcsv(trim($line));
        if (count($parts) < 3) {
            $removed++;
            continue;
        }

        $time = strtotime($parts[2]);
        if ($time && ($now - $time) <= $maxAge) {
            $filtered[] = $line;
        } else {
            $removed++;
        }
    }

    $totalKept = count($filtered);
    file_put_contents($file, implode('', array_merge($headers, $filtered)));
    logLine("Processed $file – removed $removed old or malformed entries, kept $totalKept.");
}

// Write log to file
$logFile = __DIR__ . '/prune.log';
file_put_contents($logFile, implode("\n", $log) . "\n", FILE_APPEND | LOCK_EX);
