document.addEventListener("DOMContentLoaded", function () {
  // Use global values or fallbacks
  const conversionName     = encodeURIComponent(window.pineConversionName     || 'Lead');
  const conversionValue    = encodeURIComponent(window.pineConversionValue    || '0.00');
  const conversionCurrency = encodeURIComponent(window.pineConversionCurrency || 'EUR');

  // Try to write conversion silently if consent was already given (via checkout form)
  fetch('/pinetrack/consent-handler.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: 'check=1'
        + '&conversion=' + conversionName
        + '&conversion_value=' + conversionValue
        + '&conversion_currency=' + conversionCurrency
  })
  .then(res => res.text())
  .then(text => {
    if (text.includes('Consent confirmed')) {
      console.log("PineTrack: consent already present, conversion written.");
      return;
    }

    // No consent yet – show buttons
    loadPineConsentUI(conversionName, conversionValue, conversionCurrency);
  })
  .catch(err => console.warn("PineTrack error:", err));
});

function loadPineConsentUI(conversionName, conversionValue, conversionCurrency) {
  fetch('/pinetrack/consent-ui.html')
    .then(res => res.text())
    .then(html => {
      const container = document.createElement('div');
      container.innerHTML = html;
      document.body.appendChild(container);

      const yesBtn = document.getElementById('pine-yes');
      const noBtn  = document.getElementById('pine-no');
      const msgEl  = document.getElementById('pinetrack-response');

      if (!yesBtn || !noBtn || !msgEl) {
        console.warn("PineTrack: Consent UI elements not found.");
        return;
      }

      yesBtn.addEventListener('click', function () {
        fetch('/pinetrack/consent-handler.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
          body: 'consent_marketing=1'
              + '&conversion=' + conversionName
              + '&conversion_value=' + conversionValue
              + '&conversion_currency=' + conversionCurrency
        })
        .then(res => res.text())
        .then(result => {
          msgEl.innerText = "Vielen Dank – wir haben die Zustimmung gespeichert.";
          yesBtn.disabled = true;
          noBtn.disabled = true;

          // Fade out after short delay
          setTimeout(() => {
            document.getElementById('pinetrack-consent').classList.add('fade-out');
          }, 3000);
        });
      });

      noBtn.addEventListener('click', function () {
        msgEl.innerText = "Verstanden – es erfolgt keine Zuordnung.";
        yesBtn.disabled = true;
        noBtn.disabled = true;

        // Fade out after short delay
        setTimeout(() => {
          document.getElementById('pinetrack-consent').classList.add('fade-out');
        }, 3000);
      });
    });
}
